//%attributes = {"publishedSql":true}
// Procedure BLOBPosition
//BLOBPosition returns the starting position of the first occurrence of a string
//within a BLOB.
//Notes:
//   1. BLOBs are treated as arrays bytes, not characters. Each BLOB byte has a
//       numeric value, which can be converted to another form if desired.
//   2. BLOB bytes (i.e., the byte array elements) are numbered starting with
//       zero.

//-------------------------------------------------------------------------------
//   $0 is the returned position (LongInt)
//   $1 is the search string (Text)
//   $2 is a pointer to the BLOB to be searched (Pointer)
//   $3 is true if the search is Case sensitive. (Boolean)
//   $4 is the Byte Offset parameter, and is optional. (LongInt)

C_LONGINT:C283($0; $4)
C_TEXT:C284($1)
C_POINTER:C301($2)
C_BOOLEAN:C305($3)
C_TEXT:C284($SearchString)
C_POINTER:C301($BLOBPointer)
C_BOOLEAN:C305($CaseSensitive; $Matched; $Done)
_O_C_INTEGER:C282($SkipTableSize; $SearchStringLength; $CharacterValue; $SkipValue; $ShiftValue; $Index)
C_LONGINT:C283($ByteOffset; $BLOBSize; $BLOBIndex)

$SearchString:=$1
$BLOBPointer:=$2
$CaseSensitive:=$3
If (Count parameters:C259>3)
	$ByteOffset:=$4
Else 
	$ByteOffset:=0
End if 

$BLOBSize:=BLOB size:C605($BLOBPointer->)
$SearchStringLength:=Length:C16($SearchString)

$0:=-1

//Should we even attemp a search?
If ((($BLOBSize-$ByteOffset)>=$SearchStringLength) & ($ByteOffset>=0) & ($ByteOffset<$BLOBSize))
	//Set up the Skip Table.
	$SkipTableSize:=255
	ARRAY INTEGER:C220($SkipTable; $SkipTableSize)
	For ($i; 0; $SkipTableSize)
		$SkipTable{$i}:=$SearchStringLength
	End for 
	
	$Index:=$SearchStringLength
	While ($Index>0)
		$CharacterValue:=Character code:C91($SearchString[[$Index]])
		If ($SkipTable{$CharacterValue}=$SearchStringLength)
			//The rightmost occurrence determines the skip 
			$SkipValue:=$SearchStringLength-$Index
			$SkipTable{$CharacterValue}:=$SkipValue
			If (Not:C34($CaseSensitive))
				Case of 
					: (($CharacterValue>=65) & ($CharacterValue<=90))
						$SkipTable{$CharacterValue+32}:=$SkipValue
						
					: (($CharacterValue>=97) & ($CharacterValue<=122))
						$SkipTable{$CharacterValue-32}:=$SkipValue
				End case 
			End if   //Not($CaseSensitive)
		End if   //The rightmost occurrence determines the skip table value.
		$Index:=$Index-1
	End while   //$Index<=$SearchStringLength
	
	//Scan the BLOB
	$BLOBIndex:=$ByteOffset
	$Done:=False:C215
	While (Not:C34($Done))
		$Index:=$SearchStringLength
		If ($CaseSensitive)
			
			$Matched:=(Character code:C91($SearchString[[$Index]])=$BLOBPointer->{($BLOBIndex+$Index-1)})
		Else 
			
			$Matched:=($SearchString[[$Index]]=Char:C90($BLOBPointer->{($BLOBIndex+$Index-1)}))
		End if   //$CaseSensitive
		
		While ($Matched & ($Index>1))
			$Index:=$Index-1
			If ($CaseSensitive)
				
				$Matched:=(Character code:C91($SearchString[[$Index]])=$BLOBPointer->{($BLOBIndex+$Index-1)})
			Else 
				
				$Matched:=($SearchString[[$Index]]=Char:C90($BLOBPointer->{($BLOBIndex+$Index-1)}))
			End if   //$CaseSensitive
		End while   //$Matched & ($Index>1)
		
		//Do we have a match?
		If (($Index<=1) & $Matched)  //Yes.
			$0:=$BLOBIndex
			$Done:=True:C214
		Else   //No match, yet.
			
			$ShiftValue:=$SkipTable{Int:C8($BLOBPointer->{($BLOBIndex+$Index-1)})}
			$ShiftValue:=$ShiftValue-($SearchStringLength-$Index)  // RL  (27-12-2001)
			$BLOBIndex:=$BLOBIndex+$ShiftValue  //Shift the search string to the  right.
			If (($BLOBIndex+$SearchStringLength)>$BLOBSize)  //No room left -- Quit
				$0:=-1
				$Done:=True:C214
			End if   //No room left -- Quit
		End if   //Do we have a match?
	End while   //Not($Done)
End if   //Should we even attemp a search?
